/**
 * 
 */
package com.ejie.ab18a.utils;

import org.w3c.dom.Document;

import com.ejie.ab18a.properties.Ab18aPropertiesManager;

import n38a.exe.N38APISesion;

/**
 * @author XXXX
 * 
 */
public abstract class Ab18aXLNETSUtils {

	/**
	 * Instantiates a new y46j xml utils.
	 */
	private Ab18aXLNETSUtils() {
		super();
	}

	/**
	 * Recupera el token de session.
	 * 
	 * @param nombreAplicacion
	 *            the nombre aplicacion
	 * @return devuelve el token de session
	 */
	public static Document getSessionToken(String nombreAplicacion) {

		N38APISesion myAPISession = new N38APISesion();
		/*
		 * Aquí abrimos una sesión de Aplicación obteniendo el document de
		 * sesión
		 */
		return myAPISession.n38APISesionCrearApp(nombreAplicacion);
	}

	public static Document getSessionTokenY46J() {

		return getSessionToken(Ab18aPropertiesManager.getProperty("COD_APLICACION"));

	}

	public static String getStringSessionTokenY46J() {
		Document documentXlnets = getSessionToken(Ab18aPropertiesManager.getProperty("COD_APLICACION"));
		return Utilidades.getStringFromDocument(documentXlnets);
	}
}
